#!/bin/sh

# Copier le contenu du fichier hostname dans la variable name
NAME="$(cat "/etc/hostname")"

# Detecter le type de carte en fonction du premier caractere du nom
if [ ${NAME:0:1} = 'C' ]; then
	BOARD="Controller $NAME"
	CTRLBOARD="Y"
elif [ ${NAME:0:1} = 'D' ]; then
	BOARD="Door-unit $NAME"
elif [ ${NAME:0:1} = 'G' ]; then
	BOARD="Graphical console $NAME"
elif [ ${NAME:0:1} = 'M' ]; then
	BOARD="Maestro $NAME"
elif [ ${NAME:0:1} = 'Q' ]; then
	BOARD="QuadDoor $NAME"
else
	BOARD="$NAME"
fi

# Voir les modules installes en fonction des caracteres qui composent le nom
if grep -q "C" "/etc/hostname"; then
	CTRL="C"
fi

# Creer le debut du fichier index.html, en remplacant le nom du board
cat /www/head.html-part | sed "s/@@@BOARD@@@/$BOARD/" > /tmp/index.html

# Copier les parties communes a tous les types de carte
cat /www/common.html-part >> /tmp/index.html

if [ $CTRLBOARD ]; then
	# C'est un board CTRL: copier la partie Modem GSM
	cat /www/smsd.html-part >> /tmp/index.html
fi
if [ $CTRL ]; then
	# Il y a un CTRL sur ce board: copier la partie Administration
	cat /www/admin.html-part >> /tmp/index.html
fi
cat /www/tail.html-part >> /tmp/index.html
