#!/bin/sh

# Copier le contenu du fichier hostname dans la variable name
NAME="$(cat "/etc/hostname")"

# Detecter le type de carte en fonction du premier caractere du nom
if [ ${NAME:0:1} = 'C' ]; then
	BOARD="Controller ARM"
elif [ ${NAME:0:1} = 'D' ]; then
	BOARD="Door-unit ARM"
else
	BOARD="UNKNOWN"
fi

# Voir les modules installes en fonction des caracteres qui composent le nom
if grep -q "C" "/etc/hostname"; then
	CTRL="C"
fi
if grep -q "D" "/etc/hostname"; then
	DOOR="D"
fi

# Creer le debut du fichier index.html, en remplacant le nom du board
cat /www/head.html-part | sed "s/@@@BOARD@@@/$BOARD/" > /tmp/index.html

# Copier les parties specifiques
if [ $CTRL ]; then
	cat /www/ctrl.html-part >> /tmp/index.html
fi
if [ $DOOR ]; then
	cat /www/door.html-part >> /tmp/index.html
fi

cat /www/common.html-part >> /tmp/index.html
if [ "$BOARD" = "Controller ARM" ]; then
	cat /www/smsd.html-part >> /tmp/index.html
fi
if [ $CTRL ]; then
	cat /www/admin.html-part >> /tmp/index.html
fi
cat /www/tail.html-part >> /tmp/index.html
