/** enable or disable all fields in this div
 * enableIt peut tre omis */
function enableDiv(divId, enableIt)
{
    if (enableIt==null)
        enableIt=true;
    var div = document.getElementById(divId);
    if (div==null)
        return;    
    div.style.color = enableIt ? 'black' : 'silver';
    if (div.tagName=='INPUT' || div.tagName=='SELECT' || div.tagName=='TEXTAREA')
    {   // action directe sur le contrle
        if (div.type=="hidden")return;
        div.disabled = !enableIt;
        return;
    }
    elems = div.getElementsByTagName('INPUT');
    for (i=0 ; i < elems.length ; i++) {
            if (elems[i].type=="hidden")
                continue;
            elems[i].disabled = !enableIt;
    }
    elems = div.getElementsByTagName('SELECT');
    for (i=0 ; i < elems.length ; i++) {
         elems[i].disabled = !enableIt;
    }
    elems = div.getElementsByTagName('TEXTAREA');
    for (i=0 ; i < elems.length ; i++) {
         elems[i].disabled = !enableIt;
    }
}
function onCheckEnableDiv (oCheck, divId, enableIt)
{
    if (enableIt==null)
        enableIt=true;
    enableDiv(divId, oCheck.checked==enableIt);
}
function initCheckEnableDiv (checkId, divId)
{
    var ocheck = document.getElementById(checkId);
    var odiv = document.getElementById(divId);    
    if (ocheck!=null && odiv!=null) {
        if (ocheck.addEventListener){
            ocheck.addEventListener('click', new Function ("onCheckEnableDiv(this,'"+divId+"')"), true);
        } else if (ocheck.attachEvent){
            ocheck.attachEvent('onclick', new Function ("onCheckEnableDiv(window.event.srcElement,'"+divId+"')"));
        }
        onCheckEnableDiv(ocheck, divId);
    }
}
function initCheckDisableDiv (checkId, divId)
{
    var ocheck = document.getElementById(checkId);
    var odiv = document.getElementById(divId);    
    if (ocheck!=null && odiv!=null) {
        if (ocheck.addEventListener){
            ocheck.addEventListener('click', new Function ("onCheckEnableDiv(this,'"+divId+"', false)"), true);
        } else if (ocheck.attachEvent){
            ocheck.attachEvent('onclick', new Function ("onCheckEnableDiv(window.event.srcElement,'"+divId+"', false)"));
        }
        onCheckEnableDiv(ocheck, divId, false);
    }
}



/** display/hide the element */
function displayDiv(divId, enableIt)
{
    if (enableIt==null)
        enableIt=true;
    var div = document.getElementById(divId);
    if (div==null)
        return;
    div.style.display = enableIt ? 'inline' : 'none';
}
function onCheckDisplayDiv (oCheck, divId, enableIt)
{
    if (enableIt==null)
        enableIt=true;
    displayDiv(divId, oCheck.checked==enableIt);
}
function initCheckDisplayDiv (checkId, divId, enableIt)
{
    if (enableIt==null)
        enableIt=true;
    var ocheck = document.getElementById(checkId);
    var odiv = document.getElementById(divId);
    if (ocheck!=null && odiv!=null) {
        if (ocheck.addEventListener){
            ocheck.addEventListener('click', new Function ("onCheckDisplayDiv(this,'"+divId+"',"+enableIt+")"), true);
        } else if (ocheck.attachEvent){
            ocheck.attachEvent('onclick', new Function ("onCheckDisplayDiv(window.event.srcElement,'"+divId+"',"+enableIt+")"));
        }
        onCheckDisplayDiv(ocheck, divId, enableIt);
    }
}

function _onSelectAction (oSelect, divBaseId, action)
{
    if (oSelect==null)
        return;
    var fn;
    if (action=="display")
        fn = displayDiv;
    else if (action=="enable")
        fn = enableDiv;
    for (var i = 0; i < oSelect.options.length; i++){
       var op = oSelect.options[i];
       fn(divBaseId+op.value, op.selected);
    }
}
function _initSelectAction (selectId, divBaseId, action)
{
    var oSelect = document.getElementById(selectId);
    if (oSelect!=null) {
        if (oSelect.addEventListener){
            oSelect.addEventListener('change', new Function ("_onSelectAction(this,'"+divBaseId+"','"+action+"')"), true);
        } else if (oSelect.attachEvent){
            oSelect.attachEvent('onchange', new Function ("_onSelectAction(window.event.srcElement,'"+divBaseId+"','"+action+"')"));
        }
        _onSelectAction(oSelect, divBaseId, action);
    }
}

/**  chaque option du select, on vrifie s'il y a un div correspondant et on l'affiche ou bien on le masque suivant que l'option est slectionne ou pas*/
function initSelectDisplayDiv (selectId, divBaseId)
{
    _initSelectAction(selectId, divBaseId, "display");
}
/**  chaque option du select, on vrifie s'il y a un div correspondant et on l'autorise  ou pas (disabled) suivant que l'option est slectionne ou pas*/
function initSelectEnableDiv (selectId, divBaseId)
{
    _initSelectAction(selectId, divBaseId, "enable");
}

function _onRadioAction (name, divBaseId, action)
{
    var fn;
    if (action=="display")
        fn = displayDiv;
    else if (action=="enable")
        fn = enableDiv;
    var oRadios = document.getElementsByName(name);
    for ( var i=0; i< oRadios.length; i++  ){
        var o = oRadios[i];
       fn(divBaseId+o.value, o.checked);
    }
}
function _initRadioAction (name, divBaseId, action)
{
    var oRadios = document.getElementsByName(name);
    for ( var i=0; i< oRadios.length; i++  ){
        var o = oRadios[i];
        if (o.addEventListener){
            o.addEventListener('click', new Function ("_onRadioAction('"+name+"','"+divBaseId+"','"+action+"')"), true);
        } else if (o.attachEvent){
            o.attachEvent('onclick', new Function ("_onRadioAction('"+name+"','"+divBaseId+"','"+action+"')"));
        }
    }
    _onRadioAction(name, divBaseId, action);
}
/**  chaque option radio, on vrifie s'il y a un div correspondant et on l'affiche ou bien on le masque suivant que l'option est slectionne ou pas*/
function initRadioDisplayDiv (name, divBaseId)
{
    _initRadioAction(name, divBaseId, "display");
}
/**  chaque option radio, on vrifie s'il y a un div correspondant et on l'autorise  ou pas (disabled) suivant que l'option est slectionne ou pas*/
function initRadioEnableDiv (name, divBaseId)
{
    _initRadioAction(name, divBaseId, "enable");
}